# Preparis Desktop Installation
In order to install the PreparisDesktop.msi a batch file has been provided which wraps the MSI to enable the 
user run the installation as administrator. Running the batch file as provided will install in the standard location
with default parameters. Additional parameters can be provided to the the msi file in order to configuration an
trace log and/or a proxy.

## Running as Administrator 

Right click on the file and select 'Run as administrator'.
Note: When running the batch file from the Command Prompt, launch the Command Prompt as administrator.

## Installation Command Options

### Default Configuration
By default the installation will not configure a proxy not will it include an installation process log. The batch 
file command is as follows:

> msiexec.exe /i "%~dp0\PreparisDesktop.msi"

### Installation Log Configuration 
If you encounter issues with the installation of the Desktop application an installation log can be configured.
Update the batch command as follows:

> msiexec.exe /i "%~dp0\PreparisDesktop.msi" /l*v "log.log"

### Proxy Configuration
If there is a need to make the Desktop app aware of your proxy server you can configurate the proxy server during
the installation process. You will need to substitue your real values for 'proxy ip' and 'proxy port'. Update the batch
command as follows:

> msiexec.exe /i "%~dp0\PreparisDesktop.msi" PROXYSERVERADDRESS="proxy ip" PROXYSERVERPORT="proxy port" USEPROXYSERVER="true"

### Proxy and Installation Log Configuration
Update the batch file as follows to support both the proxy configuration the installation log configuration:

> msiexec.exe /i "%~dp0\PreparisDesktop.msi" /l*v "log.log" PROXYSERVERADDRESS="proxy ip" PROXYSERVERPORT="proxy port" USEPROXYSERVER="true"

### Portal LDAP Code configuration
If LDAP authentication is required, portal LDAP code can be added to the setting during the Desktop application
installation process. You will need to substitute the real code value
(found in Preparis portal under Settings -> System Setting -> Company Profile) for 'user portal LDAP code'
Update the batch command as follows:

> msiexec.exe /i "%~dp0\PreparisDesktop.msi" PORTALLDAPCODE="user portal LDAP code"

if you are using secure ldaps connection, and your certificate is not validating, disable certificate validation flag must be used and set to true.
The batch command should be modified as follows:
> msiexec.exe /i "%~dp0\PreparisDesktop.msi" PORTALLDAPCODE="user portal LDAP code" LDAPSIGNORECERT=true
